/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.io;

import android.graphics.Bitmap;
import android.os.SystemClock;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import com.gprinter.bean.PrinterDevices;
import com.gprinter.io.PortManager;
import com.gprinter.utils.CallbackListener;
import com.gprinter.utils.Command;
import com.gprinter.utils.GpUtils;
import com.gprinter.utils.HexUtils;
import com.gprinter.utils.LogUtils;
import com.gprinter.utils.PDFUtils;
import com.gprinter.utils.SDKUtils;
import com.gprinter.utils.UIThreadManager;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class EthernetPort
extends PortManager {
    private static final String TAG = EthernetPort.class.getSimpleName();
    private Socket mSocket;
    private InetAddress mInetAddress;
    private String mIp;
    private int mPort;
    private SocketAddress mSocketAddress;
    int len = 0;
    private Command command = null;
    private CallbackListener callbackListener = null;
    private PingReader pingReader = null;
    private IoReader ioReader = null;
    private boolean isConn;
    private PrinterDevices mPrinterDevices;
    private byte[] buffer = new byte[128];
    private final Object lock = new Object();
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();

    public EthernetPort(PrinterDevices devices) {
        if (devices != null) {
            this.mPrinterDevices = devices;
            this.mIp = devices.getIp();
            this.mPort = devices.getPort();
            this.callbackListener = devices.getCallbackListener();
            this.command = devices.getCommand();
        }
    }

    @Override
    public boolean openPort() {
        try {
            if (this.callbackListener != null) {
                UIThreadManager.onUIThread(new Runnable(){

                    @Override
                    public void run() {
                        EthernetPort.this.callbackListener.onConnecting();
                    }
                });
            }
            this.mSocket = new Socket();
            this.mInetAddress = Inet4Address.getByName(this.mIp);
            this.mSocketAddress = new InetSocketAddress(this.mInetAddress, this.mPort);
            this.mSocket.connect(this.mSocketAddress, 10000);
            this.inputStream = this.mSocket.getInputStream();
            this.outputStream = this.mSocket.getOutputStream();
            if (this.callbackListener != null) {
                if (this.command == null) {
                    UIThreadManager.onUIThread(new Runnable(){

                        @Override
                        public void run() {
                            EthernetPort.this.callbackListener.onCheckCommand();
                        }
                    });
                    this.checkPrinterCommand();
                } else {
                    this.setSuccessListen(this.command);
                }
            }
            this.isConn = true;
            this.ioReader = new IoReader();
            this.ioReader.start();
            this.pingReader = new PingReader();
            this.pingReader.start();
            return true;
        }
        catch (UnknownHostException e) {
            Log.e((String)TAG, (String)e.getMessage());
            this.setFailureListen();
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)e.getMessage());
            this.setFailureListen();
            return false;
        }
        return false;
    }

    private void checkPrinterCommand() throws IOException {
        int status = -1;
        status = this.getPrinterStatus(Command.ESC);
        if (status == -1) {
            status = this.getPrinterStatus(Command.CPCL);
            if (status == -1) {
                status = this.getPrinterStatus(Command.TSC);
                if (status == -1) {
                    this.setFailureListen();
                } else {
                    this.setSuccessListen(Command.TSC);
                }
            } else {
                this.setSuccessListen(Command.CPCL);
            }
        } else {
            this.setSuccessListen(Command.ESC);
        }
    }

    private void setSuccessListen(Command command) {
        this.command = command;
        this.mPrinterDevices.setCommand(command);
        if (this.callbackListener != null) {
            UIThreadManager.onUIThread(new Runnable(){

                @Override
                public void run() {
                    EthernetPort.this.callbackListener.onSuccess(EthernetPort.this.mPrinterDevices);
                }
            });
        }
    }

    private void setFailureListen() {
        if (this.callbackListener != null) {
            UIThreadManager.onUIThread(new Runnable(){

                @Override
                public void run() {
                    EthernetPort.this.callbackListener.onFailure();
                }
            });
        }
    }

    @Override
    public boolean writeDataImmediately(Vector<Byte> data) throws IOException {
        try {
            if (this.mSocket != null && this.outputStream != null && data.size() > 0) {
                this.outputStream.write(SDKUtils.convertVectorByteToBytes(data), 0, data.size());
                this.outputStream.flush();
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"EthernetPort.class writeDataImmediately method error!", (Throwable)e);
            this.isConn = false;
            if (this.callbackListener != null) {
                UIThreadManager.onUIThread(new Runnable(){

                    @Override
                    public void run() {
                        EthernetPort.this.callbackListener.onDisconnect();
                    }
                });
            }
            throw e;
        }
        finally {
            data.clear();
        }
        return false;
    }

    @Override
    public boolean writeDataImmediately(byte[] data) throws IOException {
        try {
            if (this.mSocket != null && this.outputStream != null && data != null && data.length > 0) {
                this.outputStream.write(data, 0, data.length);
                this.outputStream.flush();
                return true;
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"EthernetPort.class writeDataImmediately method error!", (Throwable)e);
            this.isConn = false;
            if (this.callbackListener != null) {
                UIThreadManager.onUIThread(new Runnable(){

                    @Override
                    public void run() {
                        EthernetPort.this.callbackListener.onDisconnect();
                    }
                });
            }
            throw e;
        }
        return false;
    }

    @Override
    @RequiresApi(api=21)
    public boolean writePDFToEsc(File file, int width) throws Exception {
        Bitmap[] bitmaps = PDFUtils.PDFToBitmap(file, width);
        if (bitmaps == null) {
            return false;
        }
        for (int i = 0; i < bitmaps.length; ++i) {
            byte[] data = PDFUtils.drawEscPDF(bitmaps[i]);
            this.writeDataImmediately(data);
            if (i != bitmaps.length - 1) continue;
            return true;
        }
        byte[] command = new byte[]{10, 29, 86, 66, 0, 27, 64};
        this.writeDataImmediately(command);
        return false;
    }

    @Override
    @RequiresApi(api=21)
    public boolean writePDFToTsc(File file, int printWidth, int gap, boolean cut, boolean dpi200, boolean compression, int cutHeight) throws Exception {
        if (file == null) {
            throw new Exception("File cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(printWidth))) {
            throw new Exception("printWidth cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(gap))) {
            throw new Exception("gap cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(cutHeight))) {
            throw new Exception("cutHeight cannot be empty");
        }
        Bitmap[] bitmaps = PDFUtils.PDFToBitmap(file, printWidth);
        if (bitmaps == null) {
            return false;
        }
        if (gap > 0 | cutHeight == 0) {
            for (int i = 0; i < bitmaps.length; ++i) {
                byte[] data;
                String size = "\r\nSIZE " + bitmaps[i].getWidth() / (dpi200 ? 8 : 12) + " mm," + bitmaps[i].getHeight() / (dpi200 ? 8 : 12) + " mm\r\n";
                this.writeDataImmediately(size.getBytes("GB18030"));
                String GAP = "GAP " + gap + " mm,0 mm\r\n";
                if (cut && i == bitmaps.length - 1) {
                    this.writeDataImmediately("SET CUTTER 1\r\n".getBytes("GB18030"));
                } else {
                    this.writeDataImmediately("SET CUTTER OFF\r\n".getBytes("GB18030"));
                }
                this.writeDataImmediately(GAP.getBytes("GB18030"));
                String cls = "CLS\r\n";
                this.writeDataImmediately(cls.getBytes("GB18030"));
                if (compression) {
                    data = PDFUtils.drawTscPDFLib(bitmaps[i]);
                    this.writeDataImmediately(data);
                } else {
                    data = PDFUtils.drawTscPDF(bitmaps[i]);
                    this.writeDataImmediately(data);
                }
                String print = "\r\nPRINT 1\r\n";
                this.writeDataImmediately(print.getBytes("GB18030"));
                if (i != bitmaps.length - 1) continue;
                return true;
            }
        } else {
            for (int i = 0; i < bitmaps.length; ++i) {
                List<Bitmap> mlist = EthernetPort.ImageCrop(bitmaps[i], cutHeight);
                for (int j = 0; j < mlist.size(); ++j) {
                    byte[] data;
                    String size = "\r\nSIZE " + mlist.get(j).getWidth() / (dpi200 ? 8 : 12) + " mm," + mlist.get(j).getHeight() / (dpi200 ? 8 : 12) + " mm\r\n";
                    this.writeDataImmediately(size.getBytes("GB18030"));
                    String GAP = "GAP 0 mm,0 mm\r\n";
                    if (cut && j == mlist.size() - 1 && i == bitmaps.length - 1) {
                        this.writeDataImmediately("SET CUTTER 1\r\n".getBytes("GB18030"));
                    } else {
                        this.writeDataImmediately("SET CUTTER OFF\r\n".getBytes("GB18030"));
                    }
                    this.writeDataImmediately(GAP.getBytes("GB18030"));
                    String cls = "CLS\r\n";
                    this.writeDataImmediately(cls.getBytes("GB18030"));
                    if (compression) {
                        data = PDFUtils.drawTscPDFLib(mlist.get(j));
                        this.writeDataImmediately(data);
                    } else {
                        data = PDFUtils.drawTscPDF(mlist.get(j));
                        this.writeDataImmediately(data);
                    }
                    String print = "\r\nPRINT 1\r\n";
                    this.writeDataImmediately(print.getBytes("GB18030"));
                }
                if (i != bitmaps.length - 1) continue;
                mlist.clear();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean writeBitmapToTsc(Bitmap mBitmap, int printWidth, boolean cut, boolean dpi200, boolean compression, int cutHeight) throws Exception {
        if (mBitmap == null) {
            throw new Exception("Bitmap cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(printWidth))) {
            throw new Exception("printWidth cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(cutHeight))) {
            throw new Exception("cutHeight cannot be empty");
        }
        if (mBitmap != null) {
            int width = (printWidth + 7) / 8 * 8;
            int height = mBitmap.getHeight() * width / mBitmap.getWidth();
            Log.d((String)"BMP", (String)("bmp.getWidth() " + mBitmap.getWidth()));
            Bitmap rszBitmap = GpUtils.resizeImage(mBitmap, width, height);
            List<Bitmap> mlist = EthernetPort.ImageCrop(rszBitmap, cutHeight);
            for (int j = 0; j < mlist.size(); ++j) {
                String size = "\r\nSIZE " + mlist.get(j).getWidth() / (dpi200 ? 8 : 12) + " mm," + mlist.get(j).getHeight() / (dpi200 ? 8 : 12) + " mm\r\n";
                this.writeDataImmediately(size.getBytes("GB18030"));
                String gap = "GAP 0 mm,0 mm\r\n";
                this.writeDataImmediately(gap.getBytes("GB18030"));
                if (cut && j == mlist.size() - 1) {
                    this.writeDataImmediately("SET CUTTER 1\r\n".getBytes("GB18030"));
                } else {
                    this.writeDataImmediately("SET CUTTER OFF\r\n".getBytes("GB18030"));
                }
                String cls = "CLS\r\n";
                this.writeDataImmediately(cls.getBytes("GB18030"));
                byte[] data = PDFUtils.drawTscPDFLib(mlist.get(j));
                this.writeDataImmediately(data);
                String print = "\r\nPRINT 1\r\n";
                this.writeDataImmediately(print.getBytes("GB18030"));
                if (j != mlist.size() - 1) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Bitmap> ImageCrop(Bitmap bitmap, int photoheight) {
        ArrayList<Bitmap> list = new ArrayList<Bitmap>();
        int last = bitmap.getHeight() % photoheight;
        for (int i = 0; i < bitmap.getHeight() - bitmap.getHeight() % photoheight; i += photoheight) {
            list.add(EthernetPort.cutBitmap(bitmap, i, photoheight));
        }
        if (last > 0) {
            Bitmap cp = EthernetPort.cutBitmap(bitmap, bitmap.getHeight() - bitmap.getHeight() % photoheight, bitmap.getHeight() % photoheight);
            list.add(cp);
        }
        return list;
    }

    public static Bitmap cutBitmap(Bitmap bitmap, int y, int height) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        Log.e((String)String.valueOf(w), (String)String.valueOf(h));
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)y, (int)w, (int)height, null, (boolean)false);
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getPrinterStatus(Command command) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [23[DOLOOP]], but top level block is 54[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getPower() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 24[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPrinterModel(Command command) throws IOException {
        if (command == null) {
            return "";
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.byteArrayOutputStream.size() > 0) {
                this.byteArrayOutputStream.reset();
            }
        }
        switch (command) {
            case ESC: {
                byte[] esc = new byte[]{29, 73, 67};
                this.writeDataImmediately(esc);
                break;
            }
            case TSC: {
                byte[] tsc = new byte[]{126, 33, 84, 13, 10};
                this.writeDataImmediately(tsc);
                break;
            }
            case CPCL: {
                byte[] cpcl = new byte[]{27, 118};
                this.writeDataImmediately(cpcl);
            }
        }
        long endTime = SystemClock.uptimeMillis() + 2000L;
        byte[] recv = null;
        if (this.ioReader == null) {
            do {
                if (this.inputStream.available() > 0) {
                    if (recv == null) {
                        recv = new byte[this.inputStream.available()];
                    }
                    this.inputStream.read(recv);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (endTime > SystemClock.uptimeMillis());
        } else {
            Object object2 = this.lock;
            synchronized (object2) {
                while (endTime > SystemClock.uptimeMillis()) {
                    try {
                        this.lock.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        if (this.byteArrayOutputStream != null && this.byteArrayOutputStream.size() > 0) {
            LogUtils.e("model length" + this.byteArrayOutputStream.size());
            return this.byteArrayOutputStream.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] getKey() throws IOException {
        if (this.inputStream == null) {
            throw new IOException("Please connect Printer first...");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.byteArrayOutputStream.size() > 0) {
                this.byteArrayOutputStream.reset();
            }
        }
        String command = "READ_INFO ID\r\n";
        this.writeDataImmediately(command.getBytes("GB18030"));
        long endTime = SystemClock.uptimeMillis() + 2000L;
        byte[] recv = null;
        int length = 0;
        if (this.ioReader == null) {
            do {
                if (this.inputStream.available() > 0) {
                    if (recv == null) {
                        recv = new byte[this.inputStream.available()];
                    }
                    length = this.inputStream.read(recv);
                }
                if (length > 0) return null;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (endTime > SystemClock.uptimeMillis());
            return null;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            while (this.byteArrayOutputStream.size() == 0 && endTime > SystemClock.uptimeMillis()) {
                try {
                    this.lock.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.byteArrayOutputStream != null && this.byteArrayOutputStream.size() > 0) {
                length = this.byteArrayOutputStream.size();
                recv = this.byteArrayOutputStream.toByteArray();
            }
        }
        if (recv == null) return null;
        LogUtils.e("model length" + length + "\thex:\t" + HexUtils.byte2HexStr(recv));
        return recv;
    }

    @Override
    public Command getCommand() {
        return this.command;
    }

    @Override
    public boolean getConnectStatus() {
        return this.isConn;
    }

    @Override
    public PrinterDevices getPrinterDevices() {
        return this.mPrinterDevices;
    }

    @Override
    public void setCommand(Command command) {
        this.command = command;
    }

    @Override
    public int readData(byte[] bytes) throws IOException {
        if (this.mSocket == null || this.inputStream == null) {
            throw new IOException();
        }
        try {
            if (this.inputStream.available() > 0) {
                this.len = this.inputStream.read(bytes);
            }
            LogUtils.e(TAG, "printer data return : \t" + SDKUtils.bytesToHexString(bytes));
            return this.len;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Device connection device is lost");
            this.isConn = false;
            if (this.callbackListener != null) {
                UIThreadManager.onUIThread(new Runnable(){

                    @Override
                    public void run() {
                        EthernetPort.this.callbackListener.onDisconnect();
                    }
                });
            }
            throw e;
        }
    }

    @Override
    public synchronized boolean closePort() {
        try {
            this.mPrinterDevices = null;
            this.isConn = false;
            this.command = null;
            if (this.pingReader != null) {
                this.pingReader.cancel();
                this.pingReader.interrupt();
                this.pingReader = null;
            }
            if (this.ioReader != null) {
                this.ioReader.cancel();
                this.ioReader.interrupt();
                this.ioReader = null;
            }
            if (this.outputStream != null) {
                this.outputStream.flush();
                this.outputStream.close();
            }
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.byteArrayOutputStream != null) {
                this.byteArrayOutputStream.close();
            }
            if (this.mSocket != null) {
                this.mSocket.close();
                this.mSocket = null;
            }
            return true;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Close port error!", (Throwable)e);
            return false;
        }
    }

    class IoReader
    extends Thread {
        private boolean isRun = true;

        public void cancel() {
            this.isRun = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (this.isRun) {
                    LogUtils.e(TAG, "\u8bfb\u6570\u636e...");
                    EthernetPort.this.len = EthernetPort.this.inputStream.read(EthernetPort.this.buffer);
                    LogUtils.e(TAG, "len..." + EthernetPort.this.len);
                    if (EthernetPort.this.len <= 0) continue;
                    Object object = EthernetPort.this.lock;
                    synchronized (object) {
                        final byte[] receive = SDKUtils.subBytes(EthernetPort.this.buffer, 0, EthernetPort.this.len);
                        EthernetPort.this.byteArrayOutputStream.write(receive);
                        EthernetPort.this.lock.notifyAll();
                        Thread.sleep(10L);
                        UIThreadManager.onUIThread(new Runnable(){

                            @Override
                            public void run() {
                                EthernetPort.this.callbackListener.onReceive(receive);
                            }
                        });
                    }
                }
                return;
            }
            catch (Exception e) {
                if (EthernetPort.this.callbackListener == null) return;
                UIThreadManager.onUIThread(new Runnable(){

                    @Override
                    public void run() {
                        LogUtils.e(TAG, "\u65ad\u5f00\u8fde\u63a5");
                        EthernetPort.this.callbackListener.onDisconnect();
                    }
                });
            }
        }
    }

    class PingReader
    extends Thread {
        private boolean isRun = true;
        Process p;

        public void cancel() {
            this.isRun = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (this.isRun) {
                    try {
                        PingReader.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    try {
                        this.p = Runtime.getRuntime().exec("ping -c 2 -w 2 " + EthernetPort.this.mIp);
                        InputStream input = this.p.getInputStream();
                        BufferedReader in = new BufferedReader(new InputStreamReader(input));
                        StringBuffer buffer = new StringBuffer();
                        String line = "";
                        while ((line = in.readLine()) != null) {
                            buffer.append(line);
                        }
                        input.close();
                        in.close();
                        if (buffer.toString().indexOf("100%") != -1 || buffer.toString().equals("")) {
                            EthernetPort.this.isConn = false;
                            if (EthernetPort.this.callbackListener == null) continue;
                            if (EthernetPort.this.pingReader != null) {
                                EthernetPort.this.pingReader.cancel();
                            }
                            UIThreadManager.onUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    LogUtils.e("onDisconnect...");
                                    EthernetPort.this.callbackListener.onDisconnect();
                                }
                            });
                            continue;
                        }
                        LogUtils.e("connecting...");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        this.p.destroy();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

